#include <iostream>
#include "tnt.h"
#include "fcscmat.h"
#include "fspvec.h"

using namespace std;
using namespace TNT;

typedef Fortran_Sparse_Col_Matrix<double> SparseMatrix;

int main()
{

   // build the following sparse matrix in compressed-column
   //
   //
   //    1.1  0.0  0.0  0.0 
   //    0.0  2.0  3.1  0.0
   //    3.3  0.0  0.0  8.9
   //    0.0  0.0  0.0  4.5
   //    

   SparseMatrix  A(4, 4, 6, 
                    " 1.9  3.3   2.7   3.1   8.9  4.5 ",
                    "  1    2     2     2     3    4 ",
                    "  1    3     4     5     7");


    cout.precision(4);

    cout << A << endl;



    // adjusting elements directly

    A.val(2) = 9.9;
    A.row_ind(2) =  6;

    SparseMatrix B = A;

    cout << A << endl;
    cout << B << endl;


    // illustrate reassignments

    B.val(1) = 1.1;
    B.val(2) = 1.2;
    B.val(3) = 1.3;
    B.row_ind(1) = 7;
    B.row_ind(2) = 8;
    B.row_ind(3) = 9;

    cout << B << endl;


   // create sparse 3x3 matrix with 5 nonzeros
   //
   double   values[5] = { 1.1,   2.1,  3.1,   4.7,   5.2};
   Subscript  rows[5] = {  2,     3,    1,     2,     1};
   Subscript  cols[4] = {  1,    3,     4,   5};

   SparseMatrix C(3, 3, 5, values, rows, cols);
   cout << C << endl;

   return 0;
}



