#include "header.h"

namespace TNT
{
  template <class T>
    T abs(Vector<T> A)
    {
      return (sqrt(dot_prod(A,A)));
    }
  
  
  template <class T>
    Vector<T> operator*(T c, const Vector<T> &A)
    {
      Subscript N = A.dim();
      
      Vector<T> tmp(N);
      Subscript i;
      
      for (i=0; i<N; i++)
	tmp[i] = c * A[i];
      
      return tmp;
    }
  
  template <class T>
    Vector<T> operator*(const Vector<T> &A, T c)
    {
      return(c * A);
    }
}


void
Nvector::init(int numvecs, int length)
{
  nvecs = numvecs;
  vecsize = length;
  data.newsize(numvecs);
  for(int i=0; i < numvecs; i++)
    data[i].newsize(length);
}

Nvector::Nvector()
{
  init(0,0);
}


Nvector::Nvector(int numvecs, int length)
{
  init(numvecs, length);
}

void
Nvector::print()
{
  for (int i=0; i< nvecs; i++)
    {
      for (int j=0; j<vecsize; j++)
	printf ("%1.8f ", data[i][j]);
      printf ("\n");
    }
}












