#Gnuplot script to plot the specific heat from anneal

set xlabel "Position"
set ylabel "Temperature"
set yrange [-2:11]

plot "x.out" using 2:1 title "<x>" with lines,  \
     "x.out" using 3:1 title "x_min" with lines, \
     (x+0.2)*x+cos(14.5*x-0.3) title "f(x)" with lines

pause -1 "Hit any key to continue"

set output "x_1d.ps"
set terminal postscript
replot
