#ifndef _UNISTD_H_
#define	_UNISTD_H_

#include <sys/cdefs.h>

/* define size_t and ssize_t */
#include <shared/size_t.h>
#include <shared/ssize_t.h>

#define	 STDIN_FILENO	0	/* standard input file descriptor */
#define	STDOUT_FILENO	1	/* standard output file descriptor */
#define	STDERR_FILENO	2	/* standard error file descriptor */

__BEGIN_DECLS
int	 close(int);
__off_t	 lseek(int, __off_t, int);
ssize_t	 read(int, void *, size_t);
ssize_t	 write(int, const void *, size_t);
int			 unlink(const char *);
int      mkstemp(char *name_template);
__END_DECLS

#endif /* !_UNISTD_H_ */
