#ifndef _TIME_H_
#define	_TIME_H_

#include <machine/inttypes.h>

typedef __uint32_t time_t;
typedef	__uint32_t clock_t;

#include <sys/cdefs.h>

#ifndef CLOCKS_PER_SEC
#define CLOCKS_PER_SEC 1000000
#endif

struct tm {
  int     tm_sec;         /* seconds */
  int     tm_min;         /* minutes */
  int     tm_hour;        /* hours */
  int     tm_mday;        /* day of the month */
  int     tm_mon;         /* month */
  int     tm_year;        /* year */
  int     tm_wday;        /* day of the week */
  int     tm_yday;        /* day in the year */
  int     tm_isdst;       /* daylight saving time */
};

__BEGIN_DECLS
clock_t clock(void);
char *ctime(const time_t *);
time_t time(time_t *);
struct tm*localtime(const time_t *timep);
__END_DECLS

struct timespec {
	time_t	tv_sec;		/* seconds */
	long	tv_nsec;	/* and nanoseconds */
};

#endif /* !_TIME_H_ */
