#ifndef _SYS_VA_LIST_H
#define _SYS_VA_LIST_H

/****************************************************************************
 * Copyright (C) 2000 Matthew Frank
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the author's
 * name not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.
 *  
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Matt Frank, MIT Laboratory for Computer Science,
 *         mfrank@lcs.mit.edu
 *         2000-Nov-03
 *
 ***************************************************************************/

#include <sys/cdefs.h>

__BEGIN_DECLS

/* The v*printf functions in stdio.h needs to declare their var args
 * list parameter, but POSIX does not allow stdio.h to pollute the
 * namespace with va_list.  So stdio.h includes this file which
 * defines __va_list.  Any identifier that starts with double
 * underscores is reserved by POSIX for the implementation.  stdarg.h
 * includes this file and then defines va_list in terms of __va_list.
 */

typedef void *__va_list;

__END_DECLS

#endif  /* _SYS_VA_LIST_H */
