/****************************************************************************
 * Copyright (C) 1999 Matthew Frank
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the author's
 * name not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.
 *  
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Matt Frank, MIT Laboratory for Computer Science,
 *         mfrank@lcs.mit.edu
 *         2000-Oct-20
 *
 ***************************************************************************/

#ifndef _SYS_TYPES_H
#define _SYS_TYPES_H

#include <shared/size_t.h>
#include <shared/ssize_t.h>
#include <machine/ansi.h>

typedef __uint8_t	u_int8_t;
typedef __uint16_t	u_int16_t;
typedef __uint32_t	u_int32_t;
typedef __uint64_t	u_int64_t;

#ifndef __INT_TS_DEFINED
#define __INT_TS_DEFINED
typedef __int8_t	int8_t;
typedef __int16_t	int16_t;
typedef __int32_t	int32_t;
typedef __int64_t	int64_t;
#endif

typedef __off_t 	off_t;
typedef __mode_t 	mode_t;
typedef	u_int32_t 	uid_t; 		/* user id */
typedef	u_int32_t 	gid_t; 		/* group id */
typedef	u_int32_t	dev_t;		/* device number */
typedef	u_int32_t	ino_t;		/* inode number */
typedef	u_int16_t	nlink_t;	/* link count */


#endif /* _SYS_TYPES_H */
