#ifndef _STRING_H_
#define	_STRING_H_

#include <sys/cdefs.h>

__BEGIN_DECLS

#include <shared/size_t.h>
#include <shared/null.h>

void *memcpy(void *dest, const void *src, size_t n);
int memcmp(const void *s1, const void *s2, size_t n);

/* FIXME: this isn't ANSI, so we should get rid of it.  The only
   reason I'm including it is because rgcc is turning memcpy into
   bcopy. */
void bcopy(const void* src, void* dest, size_t n);

size_t strlen(const char *str);
size_t strnlen(const char *str, size_t max_len);

char *strdup(const char* str);

char *strchr(const char *p, const int ch);
char *strrchr(const char *p, const int ch);

char *strcpy(char *to, const char *from);
char *strncpy(char *dst, const char *src, size_t n);

char *strcat(char *dest, const char *src);
char *strncat(char *dest, const char *src, size_t n);

int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t n);

size_t strspn(const char *s, const char *accept);
size_t strcspn(const char *s, const char *reject);

char *strerror(int errnum);

char *strpbrk(const char *s, const char *accept);

char *strstr(const char *haystack, const char *needle);

__END_DECLS

#endif /* _STRING_H_ */
