#ifndef _STDLIB_H_
#define	_STDLIB_H_

#include <sys/cdefs.h>
#include <machine/inttypes.h>

/* define NULL */
#include <shared/null.h>

#define RAND_MAX 2147483645

#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0

__BEGIN_DECLS

int	      rand(void);
void	      srand(unsigned);

double        atof(const char *);
int           atoi(const char *);
long          atol(const char *);
long	      strtol(const char *, char **, int);
unsigned long strtoul(const char *, char **, int);
__int64_t     strtoll(const char *, char **, int);
__uint64_t    strtoull(const char *, char **, int);
double        strtod(const char *, char **);
char         *getenv(const char *);

/* define size_t */
#include <shared/size_t.h>

void *        malloc(size_t);
void free(void*);

void *calloc(size_t nmemb, size_t size);
void *realloc(void *ptr, size_t size);

void qsort(void *base, size_t nmemb, size_t size,
           int(*compar)(const void *, const void *));

void *bsearch(const void *key, const void *base, size_t nmemb,
              size_t size, int (*compar)(const void *, const void *));

char *ecvt(double number, int ndigits, int *decpt, int *sign);

char *fcvt(double number, int ndigits, int *decpt, int *sign);

int atexit(void (*function)(void));


__END_DECLS

#endif /* _STDLIB_H_ */
