#ifndef _STDIO_H_
#define	_STDIO_H_

#include <sys/cdefs.h>
#include <machine/inttypes.h>
#include <machine/ansi.h>
#include <sys/va_list.h>

/* define NULL */
#include <shared/null.h>
#include <shared/size_t.h>

__BEGIN_DECLS
typedef int (*__FILE_close_func_t)(void *fp);
typedef int (*__FILE_feof_func_t)(void *fp);
typedef int (*__FILE_read_func_t)(void *fp, void *buf, int size);
typedef int (*__FILE_ungetc_func_t)(void *fp, int resetchar);
typedef int (*__FILE_write_func_t)(void *fp, const void *buf, int size);
typedef int (*__FILE_flush_func_t)(void *fp);
typedef __off_t (*__FILE_seek_func_t)(void *fp, __off_t off, int whence);
typedef int (*__FILE_fileno_func_t)(void *fp);
typedef int (*__FILE_clearerr_func_t)(void *fp);
typedef int (*__FILE_ferror_func_t)(void *fp);

typedef struct __FILE_struct {
  __FILE_close_func_t close;
  __FILE_feof_func_t feof;
  __FILE_read_func_t read;
  __FILE_ungetc_func_t ungetc;
  __FILE_write_func_t write;
  __FILE_flush_func_t flush;
  __FILE_seek_func_t seek;
  __FILE_fileno_func_t fileno;
  __FILE_clearerr_func_t clearerr;
  __FILE_ferror_func_t ferror;
} FILE;

typedef struct __UNBUF_STREAM_struct __UNBUF_STREAM_t;
__UNBUF_STREAM_t* __unbuf_istream_open(const char *pathname);
__UNBUF_STREAM_t* __unbuf_istream_fdopen(int fd);
__UNBUF_STREAM_t* __unbuf_ostream_open(const char *pathname);
__UNBUF_STREAM_t* __unbuf_ostream_open_append(const char *pathname);
__UNBUF_STREAM_t* __unbuf_ostream_fdopen(int fd);
__UNBUF_STREAM_t* __unbuf_ostream_fdopen_append(int fd);

typedef struct __STRING_STREAM_struct __STRING_STREAM_t;
__STRING_STREAM_t* __string_istream_open(char *str);
__STRING_STREAM_t* __string_ostream_open(char *str);

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

__END_DECLS

/*
 * The following three definitions are for ANSI C, which took them
 * from System V, which brilliantly took internal interface macros and
 * made them official arguments to setvbuf(), without renaming them.
 * Hence, these ugly _IOxxx names are *supposed* to appear in user code.
 *
 */
#define _IOFBF  0               /* setvbuf should set fully buffered */
#define _IOLBF  1               /* setvbuf should set line buffered */
#define _IONBF  2               /* setvbuf should set unbuffered */
#define	BUFSIZ	1024		/* size of buffer used by setbuf */
#define	EOF	(-1)

#define	SEEK_SET	0	/* set file offset to offset */
#define	SEEK_CUR	1	/* set file offset to current plus offset */
#define	SEEK_END	2	/* set file offset to EOF plus offset */

__BEGIN_DECLS
int	 fclose(FILE *);
int	 feof(FILE *);
int	 ferror(FILE *);
int	 fflush(FILE *);
int	 fgetc(FILE *);
char	*fgets(char *, int, FILE *);
FILE	*fopen(const char *, const char *);
FILE	*fdopen(const int, const char *);
int	 fprintf(FILE *, const char *, ...);
int	 fputc(int, FILE *);
int	 fputs(const char *, FILE *);
size_t	 fread(void *, size_t, size_t, FILE *);
int	 fscanf(FILE *, const char *, ...);
int	 fseek(FILE *, long, int);
size_t	 fwrite(const void *, size_t, size_t, FILE *);
int	 fileno(FILE *);
void	 clearerr(FILE *);
int	 getc(FILE *);
int	 getchar(void);
long	 ftell(FILE *);
/* char	*gets(char *); */ /* gets() not supported because there is no way to specify maximum buffer size, use fgets instead */

void	 perror(const char *);
int	 printf(const char *, ...);
int	 putc(int, FILE *);
int	 putchar(int);
int	 puts(const char *);
int	 remove(const char *);
int	 rename (const char *, const char *);
void	 rewind(FILE *);
int	 scanf(const char *, ...);
void	 setbuf(FILE *, char *);
int	 setvbuf(FILE *, char *, int, size_t);
int	 sprintf(char *, const char *, ...);
int	 sscanf(char *, const char *, ...);
FILE	*tmpfile(void);
char	*tmpnam(char *);
int	 ungetc(int, FILE *);
int	 vfprintf(FILE *, const char *, __va_list);
int      vfscanf(FILE *, char const *, __va_list);
int	 vprintf(const char *, __va_list);
int      vscanf(const char*, __va_list);
int	 vsprintf(char *, const char *, __va_list);
int      vsscanf(char *, const char *, __va_list);


__END_DECLS

#define getc(fp) fgetc(fp)
#define getchar() getc(stdin)
#define putc(c, fp) fputc(c, fp)
#define putchar(c) putc(c, stdout)

#endif /* _STDIO_H_ */
