#ifndef _STDARG_H
#define _STDARG_H

/****************************************************************************
 * Copyright (C) 2000 Matthew Frank
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the author's
 * name not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.
 *  
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Matt Frank, MIT Laboratory for Computer Science,
 *         mfrank@lcs.mit.edu
 *         2000-Nov-03
 *
 ***************************************************************************/

#include <sys/cdefs.h>

__BEGIN_DECLS

/* The v*printf functions in stdio.h needs to declare their var args
 * list parameter, but POSIX does not allow stdio.h to pollute the
 * namespace with va_list.  So stdio.h includes sys/va_list.h.
 * stdarg.h *should* define va_list, which we do in terms of __va_list.
 */

#include <sys/va_list.h>
#ifndef _VA_LIST
#define _VA_LIST
typedef __va_list va_list;
#endif

#define va_start(__aplist, lastarg) (__aplist = ((va_list) __builtin_next_arg (lastarg)))

#undef va_end
extern void va_end(va_list);        /* defined in libgcc.a */
#define va_end(__aplist) ((void)0)

#define va_arg(__aplist, __argtype) \
  *((__argtype *) (void *) ((int)(__aplist = (void*)((int)__aplist + 8)) - 8))

/* Copy va_list into another variable of this type.  */
#define __va_copy(dest, src) (dest) = (src)

__END_DECLS

#endif /* _STDARG_H */
