/****************************************************************************
 * Copyright (C) 2003 Matthew Frank
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the author's
 * name not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.
 *  
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Matt Frank, University of Illinois
 *         mif@uiuc.edu
 *         2003-Nov-24
 *
 ***************************************************************************/

#ifndef _MACHINE_SETJMP_H
#define _MACHINE_SETJMP_H

#include <machine/inttypes.h>

typedef struct __mips_jmpbuf_struct {
  __uint32_t r16;
  __uint32_t r17;
  __uint32_t r18;
  __uint32_t r19;
  __uint32_t r20;
  __uint32_t r21;
  __uint32_t r22;
  __uint32_t r23;
  __uint32_t r24;
  __uint32_t r25;
  __uint32_t r26;
  __uint32_t r27;
  __uint32_t gp;                /* global pointer */
  __uint32_t sp;                /* stack pointer */
  __uint32_t r30;
  __uint32_t ra;                /* return address */
} __jmp_buf[1];

#endif /* _MACHINE_SETJMP_H */
