/****************************************************************************
 * Copyright (C) 1999 Matthew Frank
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the author's
 * name not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.
 *  
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Matt Frank, MIT Laboratory for Computer Science,
 *         mfrank@lcs.mit.edu
 *         1999-Jul-16
 *
 ***************************************************************************/

#ifndef _RAW_INTTYPES_H
#define _RAW_INTTYPES_H

#if ((__GNUC__ == 2) && (__GNUC_MINOR__ >= 7))

/* make use of special gnu syntax for defining type attributes: */

typedef signed int __int8_t __attribute__ ((__mode__ (__QI__)));
typedef signed int __int16_t __attribute__ ((__mode__ (__HI__)));
typedef signed int __int32_t __attribute__ ((__mode__ (__SI__)));
typedef signed int __int64_t __attribute__ ((__mode__ (__DI__)));

typedef unsigned int __uint8_t __attribute__ ((__mode__ (__QI__)));
typedef unsigned int __uint16_t __attribute__ ((__mode__ (__HI__)));
typedef unsigned int __uint32_t __attribute__ ((__mode__ (__SI__)));
typedef unsigned int __uint64_t __attribute__ ((__mode__ (__DI__)));

#else /* gnuc >= 2.7 */

/* we get along as best we can and hope these are right (they should
   be for almost all 32 bit systems): */

typedef signed long long   __int64_t;
typedef signed int         __int32_t;
typedef signed short       __int16_t;
typedef signed char        __int8_t;
 
typedef unsigned long long __uint64_t;
typedef unsigned int       __uint32_t;
typedef unsigned short     __uint16_t;
typedef unsigned char      __uint8_t;

#endif /* gnuc >= 2.7 */

typedef __int32_t __intptr_t;
typedef __uint32_t __uintptr_t;

#endif /* _RAW_INTTYPES_H */
