#ifndef _GETCLK_H_
#define _GETCLK_H_

#include <machine/inttypes.h>
#if !defined(UNIX_VERSION)
void _initclk(int handle);
void _startclk(int handle);
void _stopclk(int handle);
void _printclk(int handle);
#else
#define CLOCKS_PER_SEC 1000000l
long int clock(void);
#define _initclk(x) printf("initclk: %ld\n", clock())
#define _startclk(x) printf("startclk: %ld\n", clock())
#define _stopclk(x) printf("stopclk: %ld\n", clock())
#define _printclk(x) printf("printclk: %ld\n", clock());
#endif

#endif /* _GETCLK_H_ */
