#ifndef MYCLK_H_GUARD
#define MYCLK_H_GUARD

typedef struct foo_bar_t {
  __uint32_t start;
  __uint32_t total;
} mytimer_t;

static inline
void
myinitclk(mytimer_t* t)
{
  t->start = 0;
  t->total = 0;
}

static inline
void
mystartclk(mytimer_t* t)
{
  t->start = (__uint32_t)__suds_getclk();
}

static inline
void
mystopclk(mytimer_t* t)
{
  t->total += (__uint32_t)__suds_getclk() - t->start;
}

static inline
void
myprintclk(mytimer_t* t)
{
  printf("%u\n", t->total);
}

#endif MYCLK_H_GUARD
