#ifndef SUDS_CPR_H
#define SUDS_CPR_H

#include <machine/inttypes.h>

#define __CPR_NUM_QS 32
#define __CPR_MAX_Q_LEN 16384

typedef __uint32_t __cpr_qdata_t[__CPR_MAX_Q_LEN];

extern __cpr_qdata_t __cpr_data_space[__CPR_NUM_QS];

#define _cpr_q_declare(qnum) \
  unsigned *_cpr_q ## qnum ## front; \
  unsigned *_cpr_q ## qnum ## back

  
#define _cpr_q_alloc(qnum) \
  _cpr_q ## qnum ## front = __cpr_data_space[qnum]; \
  _cpr_q ## qnum ## back =   _cpr_q ## qnum ## front;

#define _cpr_q_push_uint32(qnum, val) \
  *((_cpr_q ## qnum ## front)++) = val;

#define _cpr_q_empty(qnum) \
  (_cpr_q ## qnum ## back) >= (_cpr_q ## qnum ## front)

#define _cpr_q_pop_uint32(qnum) \
  *((_cpr_q ## qnum ## back)++)

#define _cpr_q_dealloc(qnum)

static inline
void
_suds_aggregate_init(void *a, __uint32_t b)
{
}

static inline
void
_suds_aggregate_kill(void *a)
{
}

#endif SUDS_CPR_H
