/****************************************************************************
 * Copyright (C) 1999 Matthew Frank
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the author's
 * name not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.
 *  
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Matt Frank, MIT Laboratory for Computer Science,
 *         mfrank@lcs.mit.edu
 *         1999-Jul-16
 *
 ***************************************************************************/

#ifndef _CTYPE_H
#define _CTYPE_H

static
inline
int
isupper(int c) {
  return ((unsigned)(c-'A') <= (unsigned)('Z'-'A'));
}

static
inline
int
islower(int c) {
  return ((unsigned)(c-'a') <= (unsigned)('z'-'a'));
}

static
inline
int
toupper(int c) {
  return (islower(c) ? (c - ('a' - 'A')) : c);
}

static
inline
int
tolower(int c) {
  return (isupper(c) ? (c + ('a' - 'A')) : c);
}

static
inline
int
isalpha(int c) {
  return (isupper(c) || islower(c));
}

static
inline
int
isdigit(int c) {
  return ((unsigned)(c-'0') <= (unsigned)('9'-'0'));
}

static
inline
int
isxdigit(int c) {
  return (unsigned)(toupper(c) - 'A') <= (unsigned)('F'-'A');
}

static
inline
int
isalnum(int c) {
  return (isalpha(c) || isdigit(c));

}

static
inline
int
isspace(int c) {
  /* 0x20 = space, 0x9 = horizontal tab, 0xA = new line, 0xB =
     vertical tab, 0xC = form feed, 0xD = carriage return */
  return (c == ' ' || ((unsigned)(c-0x9) <= (unsigned)(0xd - 0x9)));
}

static
inline
int
isprint(int c) {
  return ((unsigned)(c - ' ') <= (unsigned)('~' - ' '));
}

static
inline
int
isgraph(int c) {
  return ((unsigned)(c - '!') <= (unsigned)('~' - '!'));
}

static
inline
int
ispunct(int c) {
  return (isgraph(c) && !isalnum(c));
}

static
inline
int
iscntrl(int c) {
  return (((unsigned)c < 0x20) || (c == 0x7f));
}

static
inline
int
isascii(int c) {
  return ((unsigned)c <= 0x7f);
}

#endif /* _CTYPE_H */
