#undef assert

#ifdef NDEBUG
#define	assert(e)	((void)0)
#else  /* NDEBUG */
#if defined(__GNUC__)
#define	assert(e)	((e) ? (void)0 : __assert(__FILE__, __LINE__, __PRETTY_FUNCTION__, #e))
#else /* for non-gcc compilers: */
#define	assert(e)	((e) ? (void)0 : __assert(__FILE__, __LINE__, "", #e))
#endif /* GNUC */
#endif /* NDEBUG */

#include <sys/cdefs.h>

__BEGIN_DECLS
void __assert(const char *file_name,
              int line_num,
              const char *func_name,
              const char *expr_string);
__END_DECLS
