#include <stdio.h>
#include <stdlib.h>

struct request {
  int rtype;                     /* 1 for malloc, 0 for free */
  unsigned data;
};

#define MR 1
#define FR 0
#define DONE -1

struct request req_list[] = {
  /* 0: */ {MR, 0x119000},
  /* 1: */ {MR, 0x119000},
  /* 2: */ {MR, 0x119000},
  /* 3: */ {MR, 0x400},
  /* 4: */ {MR, 0x208},
  /* 5: */ {FR, 4},            /* free chunk alloced by MR number 4 */
  /* 6: */ {MR, 0x1008},
  /* 7: */ {MR, 0x18},
  /* 8: */ {MR, 0x18},
  /* 9: */ {MR, 0x18},
  /* 10: */ {MR, 0x18},
  /* 11: */ {MR, 0x18},
  /* 12: */ {MR, 0x18},
  /* 13: */ {MR, 0x28},
  /* 14: */ {MR, 0x48},
  /* 15: */ {MR, 0x208},
  /* 16: */ {MR, 0x18},
  /* 17: */ {MR, 0x18},
  /* 18: */ {MR, 0x18},
  /* 19: */ {MR, 0x108},
  /* 20: */ {FR, 6},
  /* 21: */ {FR, 7},
  /* 22: */ {FR, 8},
  /* 23: */ {FR, 9},
  /* 24: */ {FR, 10},
  /* 25: */ {FR, 11},
  /* 26: */ {FR, 12},
  /* 27: */ {FR, 13},
  /* 28: */ {FR, 14},
  /* 29: */ {FR, 15},
  /* 30: */ {FR, 16},
  /* 31: */ {FR, 17},
  /* 32: */ {FR, 18},
  /* 33: */ {FR, 19},
  /* 34: */ {MR, 0x408},
  /* 35: */ {FR, 34},

  /* 36: */ {MR, 0x1008},
  /* 37: */ {MR, 0x18},
  /* 38: */ {MR, 0x18},
  /* 39: */ {MR, 0x18},
  /* 40: */ {MR, 0x18},
  /* 41: */ {MR, 0x18},
  /* 42: */ {MR, 0x18},
  /* 43: */ {MR, 0x18},
  /* 44: */ {MR, 0x18},
  /* 45: */ {MR, 0x28},
  /* 46: */ {MR, 0x28},
  /* 47: */ {MR, 0x48},
  /* 48: */ {MR, 0x108},
  /* 49: */ {MR, 0x208},
  /* 50: */ {MR, 0x18},
  /* 51: */ {MR, 0x18},
  /* 52: */ {MR, 0x88},
  /* 53: */ {FR,  36},
  /* 54: */ {FR,  37},
  /* 55: */ {FR,  38},
  /* 56: */ {FR,  39},
  /* 57: */ {FR,  40},
  /* 58: */ {FR,  41},
  /* 59: */ {FR,  42},
  /* 60: */ {FR,  43},
  /* 61: */ {FR,  44},
  /* 62: */ {FR,  45},
  /* 63: */ {FR,  46},
  /* 64: */ {FR,  47},
  /* 65: */ {FR,  48},
  /* 66: */ {FR,  49},
  /* 67: */ {FR,  50},
  /* 68: */ {FR,  51},
  /* 69: */ {FR,  52},
  /* 70: */ {MR, 0x208},
  /* 71: */ {FR,  70},
  /* 72: */ {MR, 0x1008},
  /* 73: */ {MR, 0x18},
  /* 74: */ {MR, 0x18},
  /* 75: */ {MR, 0x18},
  /* 76: */ {MR, 0x18},
  /* 77: */ {MR, 0x18},
  /* 78: */ {MR, 0x18},
  /* 79: */ {MR, 0x18},
  /* 80: */ {MR, 0x18},
  /* 81: */ {MR, 0x28},
  /* : */ {DONE, 0}
};


int
_user_main(int argc,
           char *argv[])
{
  int i = 0;
  extern int __malloc_spew_info;
  extern void __malloc_container_print();
  __malloc_spew_info = 1;
  while (req_list[i].rtype != DONE) {
/*    printf("%d %x\n", req_list[i].rtype, req_list[i].data); */
    switch (req_list[i].rtype) {
    case FR: {
      free((void*)(req_list[req_list[i].data].data));
      break;
    }
    case MR: {
      req_list[i].data = (unsigned) malloc(req_list[i].data);
      break;
    }
    default: {
      printf("error!\n");
      break;
    }
    }
    __malloc_arena_print();
    __malloc_container_print();
    i = i + 1;
  }
  return 0;
}
