#include <machine/suds_primops.h>
#include <inttypes.h>

int
write(int fd, const void *buf, int count)
{
  return (int)(__suds_syscall(0x83, (uint32_t)fd, (uint32_t)buf, (uint32_t)count));
}

char out_string[128];

int get_result(uint32_t seed);

void
_start(int argc, char* argv[])
{
  int i = 0;
  int sum = 0;
  uint64_t inner_seed = 0x1234abcd330eULL;

/*  write(0, "starting loop\n", 14); */

  for (i = 0; i < 500; i++) {
    int j;
    int thing = 1;
    /* inner seed is same as rand48 */
    inner_seed = (((inner_seed * 0x5deece66dULL) + 11ULL)
                   & 0xffffffffffffULL);
    sum = sum + get_result(inner_seed);
  }

  {
    char* endptr = &out_string[127];
    *endptr = '\0';
    *--endptr = '\n';
    do {
      *--endptr = (sum % 10) + '0';
      sum /= 10;
    } while (sum != 0);
    write (0, endptr, (unsigned)(&out_string[127]) - (unsigned)endptr);
  }

/*  write(0, "halting\n", 8); */


  /* this constructs a halt instruction: */
  __asm__ ("halt");
}

int get_result(uint32_t seed)
{
  // count is in range 1...16
  int count = ((seed >> 28) & 0xff) + 1;
  int j;
  int thing = 1;
  for (j = 0; j < count; j++) {
    thing = (thing * 13) % 207;
  }
  return thing;
}
