#include <machine/suds_primops.h>
#include <inttypes.h>

int
write(int fd, const void *buf, int count)
{
  return (int)(__suds_syscall(0x83, (uint32_t)fd, (uint32_t)buf, (uint32_t)count));
}

char out_string[128];

int get_result(uint32_t seed);

void
_start(int argc, char* argv[])
{
  int i = 0;
  int sum = 0;
  uint64_t inner_seed = 0x1234abcd330eULL;

/*  write(0, "starting loop\n", 14); */

  for (i = 0; i < 500; i++) {
    int j;
    int thing = 1;
    /* inner seed is same as rand48 */
    inner_seed = (((inner_seed * 0x5deece66dULL) + 11ULL)
                   & 0xffffffffffffULL);
    sum = bsearch(inner_seed & 0x3fffff, sum);
  }

  {
    char* endptr = &out_string[127];
    *endptr = '\0';
    *--endptr = '\n';
    do {
      *--endptr = (sum % 10) + '0';
      sum /= 10;
    } while (sum != 0);
    write (0, endptr, (unsigned)(&out_string[127]) - (unsigned)endptr);
  }

/*  write(0, "halting\n", 8); */


  /* this constructs a halt instruction: */
  __asm__ ("halt");
}

static inline
uint32_t
value_of(uint32_t index)
{
  return index + index + 1;
}

int bsearch(uint32_t value, int sum)
{
  uint32_t left_index = 0;
  uint32_t right_index = 1 << 20;

  while (left_index < right_index) {
    uint32_t mid_index = (left_index + right_index) >> 1;
    uint32_t vmid = value_of(mid_index);
    if (value < vmid) {
      right_index = mid_index-1;
    }
    else if (value > vmid) {
      left_index = mid_index + 1;
    }
    else return mid_index + sum;
  }
  return sum - 1;
}
