#ifndef VAR_SYM_H_GUARD
#define VAR_SYM_H_GUARD

typedef struct input_buf_struct
{
  stream_state *in_stream;       /* the input file position pointer */
  /* the following are sizes in bits */
  int n_bits;                   /* number of bits/code */
  int input_offset;             /* current bit offset into input_buf */
  int size;                     /* size of input_buf in bits */
  char_type input_buf[BITS];    /* the array of input tokens */
} input_buf_t;

/* Clear the input and go back to using symbols of length INIT_BITS.
 * Returns 0 for success or -1 for EOF. */
int
input_clear_codes(input_buf_t *ib);

/* Check if the next entry will be too big for the current code size,
 * if so then increase the symbol size and read in a new buffer.
 * Returns 0 for success or -1 for EOF. */
int
input_check_bits(code_int free_ent,
                 const int maxbits,
                 input_buf_t *ib);

/* Get another symbol off the input. Return the new symbol or -1 for
 * EOF. */
code_int
getcode(input_buf_t *ib);

/* Initialize ib and attach it to input stream in_stream. */
void
input_initialize(input_buf_t *ib,
                 stream_state *in_stream);

typedef struct output_buf_struct
{
  stream_state *out_stream;      /* the output file position pointer */
  int n_bits;                   /* number of bits/code */
  int output_offset;            /* current bit offset into buf */
  long int bytes_out;           /* length of compressed output */
  char buf[BITS];               /* the array of output tokens */
} output_buf_t;

/* Put another symbol on the output.  We assume output_check_bits has
 * already been called to ensure that code fits inside the current
 * n_bits. */
void
output(code_int code,
       output_buf_t *ob);

/* make sure that a code of size free_ent will fit in the current
 * symbol size, if not, increase the symbol size.  NOTE: we don't
 * check that free_ent fits inside the maximum symbol size (given by
 * maxbits), that should be checked independently */
void
output_check_bits(code_int free_ent,
                  output_buf_t *ob);

/* Put a CLEAR code on the output, decrease n_bits to INIT_BITS and
 * clear the buffers. */
void
output_clear(output_buf_t *ob);

/* Flush the output buffer */
void
output_eof(output_buf_t *ob);

/* how many bytes have we written out so far? */
long int
var_sym_output_length(output_buf_t *ob);

/* Initialize ob and attach it to output stream out_stream */
void
output_initialize(output_buf_t *ob,
                  const int maxbits,
                  const int block_compress,
                  stream_state *out_stream);

#endif VAR_SYM_H_GUARD
