#include "compress.h"

/*
static int input_offset = 0, size = 0;
static char_type input_buf[BITS];
*/
/* static stream_state in_stream; static stream_state out_stream; */

static /* inline */
code_int
get_from_buffer(char_type *buf,
		int bit_offset,
                int n_bits)
{
  int mask = ((1<<n_bits)-1);
  int byte_offset = (bit_offset >> 3);
  int r_off = (bit_offset & 0x7);
  char_type *bp = &(buf[byte_offset]);

  return (((((long)bp[2] << 16) | /* high order */
	    ((long)bp[1] << 8) | /* middle */
	    ((long)bp[0])) >> r_off) /* low order */
	  & mask);
}

static int
input_new_buffer(input_buf_t *ib)
{
  int bytes_read = readbytes(ib->in_stream,
                             (char *)(ib->input_buf),
                             ib->n_bits);
  ib->input_offset = 0;
  if ( bytes_read <= 0 )
    return EOF;			/* end of file */
  /* size is (bytes_read * 8) and then rounded to 
   * a bit somewhere in the last code
   */
  ib->size = (bytes_read << 3) - (ib->n_bits - 1);
  return 0;
}

int
input_clear_codes(input_buf_t *ib)
{
  ib->n_bits = INIT_BITS;
  return input_new_buffer(ib);
}

int
input_check_bits(code_int free_ent,
                 const int maxbits,
                 input_buf_t *ib)
{
  /*
   * If the next entry will be too big for the current code
   * size, then we must increase the size.  This implies reading
   * a new buffer full, too.
   */
  if ( (free_ent > MAXCODE(ib->n_bits)) && (ib->n_bits < maxbits) )
  {
    (ib->n_bits)++;
    return input_new_buffer(ib);
  }

  return 0;
}

code_int
getcode(input_buf_t *ib)
{
  code_int code;

  if (ib->input_offset >= ib->size) {
    if (input_new_buffer(ib) == EOF) return EOF;
  }

  code = get_from_buffer(ib->input_buf, ib->input_offset, ib->n_bits);

  ib->input_offset += ib->n_bits;

  return code;
}

void
input_initialize(input_buf_t *ib,
                 stream_state *in_stream)
{
  ib->n_bits = INIT_BITS;
  ib->input_offset = 0;
  ib->size = 0;
  ib->in_stream = in_stream;
}

/*****************************************************************************
 * OUTPUT
 ****************************************************************************/

/*
static char_type lmask[9] = {
  0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x00
};
*/
/*
static inline char_type lmask(i) {
  return (char_type)((char_type)0xff << i);
}
*/
#define lmask(i) ((char_type)((char_type)0xff << (i)))

/*
static char_type rmask[9] = {
  0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff
};
*/
/*
static inline char_type rmask(i) {
  return (char_type)((char_type)0xff >> (8-i));
}
*/
#define rmask(i) ((char_type)((char_type)0xff >> (8-i)))

static void
put_in_buffer(char *buf,
              int bit_offset,
              code_int code,
              int n_bits)
{
  int byte_offset = (bit_offset >> 3);
  int r_off = (bit_offset & 0x7);
  char *bp = &(buf[byte_offset]);

  /* VAX was little endian and allowed unaligned accesses.  The
   * original compress must have been written so that it was easy to
   * write decompress, by making the low order bits of a code arrive
   * first in the stream, then the middle order bits and finally the
   * high order bits.  This way the decompress code could just cast
   * the next code position to an int *, read it in and shift it a
   * little.  We're stuck simulating this to maintain portability on
   * big-endian machines and machines that don't allow unaligned
   * access.  oh well.  */

  /* low order bits go in byte 0 */
  *bp = (*bp & rmask(r_off)) | ((code << r_off) & lmask(r_off));

  /* middle order bits go in byte 1 */
  bp++;
  n_bits -= (8 - r_off);
  code >>= (8 - r_off);
  if (n_bits >= 8) {		/* must be at least 8 bits left */
    *bp++ = (char)code;
    code >>= 8;
    n_bits -= 8;
  }

  /* high order bits go in byte 2 */
  if (n_bits > 0) {
    *bp = code;
  }
}
    
void
output(code_int code,
       output_buf_t *ob)
{

  put_in_buffer(ob->buf, ob->output_offset, code, ob->n_bits);

  ob->output_offset += ob->n_bits;

  if ( ob->output_offset == (ob->n_bits << 3) ) {
    /*  we've got 8 codes to write out because:
     * (8 * n_bits) / (8 bits / byte) = n_bits bytes.
     */
    writebytes(ob->out_stream, ob->buf, ob->n_bits);
    ob->bytes_out += ob->n_bits;
    ob->output_offset = 0;
  }
}

void
output_check_bits(code_int free_ent,
                  output_buf_t *ob)
{
  /*
   * If the next entry is going to be too big for the code size,
   * then increase it, if possible.
   */
  if ( free_ent > MAXCODE(ob->n_bits) )
  {
    /* Write the whole buffer, because the input side won't discover
     * the size increase until after it has read the whole buffer.  */
    if ( ob->output_offset > 0 ) {
      writebytes(ob->out_stream, ob->buf, ob->n_bits );
      ob->bytes_out += ob->n_bits;
    }
    ob->output_offset = 0;

    (ob->n_bits)++;
  }
}

void
output_clear(output_buf_t *ob)
{
  put_in_buffer(ob->buf, ob->output_offset, CLEAR, ob->n_bits);

  /* Write the whole buffer, because the input side won't discover the
   * size decrease until after it has read the CLEAR code, which is in
   * the middle of this block.  We just put the CLEAR code in the
   * buffer, so we know it has (offset + n_bits) bits in it.  But we
   * still have to output all (8 * n_bits) bits = n_bits bytes,
   * because that's what decompress is going to have read already.  */
  writebytes(ob->out_stream, ob->buf, ob->n_bits );
  ob->bytes_out += ob->n_bits;
  ob->output_offset = 0;
  ob->n_bits = INIT_BITS;
}

void
output_eof(output_buf_t *ob)
{
  /* flush whatever's left in the buffer */
  if ( ob->output_offset > 0 )
    writebytes( ob->out_stream,
                ob->buf,
                ((ob->output_offset + 7) / 8) ); /* size in bytes, rounded up */
  ob->bytes_out += (ob->output_offset + 7) / 8;
  ob->output_offset = 0;
}

long int
var_sym_output_length(output_buf_t *ob)
{
  return ob->bytes_out;
}

void
output_initialize(output_buf_t *ob,
                  const int maxbits,
                  const int block_compress,
                  stream_state *out_stream)
{
  ob->out_stream = out_stream;
  ob->n_bits = INIT_BITS;
  ob->output_offset = 0;
  ob->bytes_out = put_header(maxbits, block_compress, ob->out_stream);
}
