#include "compress.h"
void printf(char*, ...);

static const char_type magic_header[] = { "\037\235" };	/* 1F 9D */

/* Defines for third byte of header */
#define BIT_MASK	0x1f
#define BLOCK_MASK	0x80
/* Masks 0x40 and 0x20 are free.  I think 0x20 should mean that there is
   a fourth header byte (for expansion).
*/

void
get_header(int *maxbits,
           int *block_compress,
           stream_state *in_stream)
{
  int flag_byte;

  /* Check the magic number */
  if ((getbyte(in_stream) != (magic_header[0] & 0xFF))
      || (getbyte(in_stream) != (magic_header[1] & 0xFF))) {
    printf("stdin: not in compressed format\n");
    exit(1);
  }

  flag_byte = getbyte(in_stream); /* set -b from file */

  *block_compress = ((flag_byte & BLOCK_MASK) != 0);
  *maxbits = flag_byte & BIT_MASK;

  if(*maxbits > BITS) {
    printf("stdin: compressed with %d bits, can only handle %d bits\n",
            *maxbits, BITS);
    exit(1);
  }
}

int
put_header(const int maxbits,
           const int block_compress,
           stream_state *out_stream)
{
  int compress_bit = (block_compress ? (BLOCK_MASK) : 0);

  putbyte(out_stream, magic_header[0]);
  putbyte(out_stream, magic_header[1]);
  putbyte(out_stream, (char)(maxbits | compress_bit));

  return 3;                     /* return number bytes written */
}

