#include "compress.h"
#include <machine/getclk.h>

/*
 * Decompress stdin to stdout.  This routine adapts to the codes in the
 * file building the "string" table on-the-fly; requiring no table to
 * be stored in the compressed file.
 */

/*
static unsigned short tab_prefix[1<<BITS];
static char_type tab_suffix[1<<BITS];
Modified to use structure to improve spatial cache locality on almost all machines:
*/

typedef unsigned tab_entry_t;

static tab_entry_t table[1<<BITS];

#define prefix_of(te) ((unsigned short)(te >> 16))
#define suffix_of(te) ((char_type)(te & 0xff))
#define tabentry_of(prefix, suffix) ((tab_entry_t)((prefix << 16) | ((char_type)suffix)))

void
decompress(const int maxbits,
           const int block_compress,
           stream_state *in_stream,
           stream_state *out_stream)
{
  code_int incode, oldcode;
  int finchar;
  code_int free_ent = FIRST(block_compress);
  input_buf_t input_buf;
/*  unsigned char* out_stream_start;
    unsigned out_stream_place; */

  input_initialize(&input_buf, in_stream);
  /*
   * initialize the first 256 entries in the table.
   */
  for ( incode = 0; incode < 256; incode++) {
    table[incode] = tabentry_of(0, (char_type)incode);
  }

  oldcode = getcode(&input_buf);
  finchar = oldcode;
  if(oldcode == EOF)            /* EOF already? */
    return;			/* Get out of here */
  /* first code must be 8 bits = char */
  putbyte(out_stream, (char_type)oldcode);

  while ( (incode = getcode(&input_buf)) > EOF ) {
    int stackp = 0;
    code_int code;
    char_type the_stack[1<<BITS];

    if ( (incode == CLEAR) && block_compress ) {
      free_ent = FIRST(block_compress) - 1;
      if (input_clear_codes(&input_buf) == EOF)
	break;      /* untimely death! */
      incode = getcode(&input_buf);
    }

    code = incode;

    /* Special case for KwKwK string. */
    if ( code >= free_ent ) {
      the_stack[stackp++] = finchar;
      code = oldcode;
    }

    /* Generate output characters in reverse order */
    while ( code >= 256 ) {
      tab_entry_t entry = table[code];
      the_stack[stackp++] = suffix_of(entry);
      code = prefix_of(entry);
    }
    finchar = suffix_of(table[code]);
    the_stack[stackp++] = finchar;

    /* And put them out in forward order */
    do
      putbyte ( out_stream, the_stack[--stackp] );
    while ( stackp > 0 );

    /* Generate the new entry. */
    if ( free_ent < MAX_MAX_CODE(maxbits) ) {
      table[free_ent] = tabentry_of((unsigned short)oldcode, finchar);
      free_ent = free_ent + 1;
      if (input_check_bits(free_ent, maxbits, &input_buf) == EOF) {
	break;			/* untimely death! */
      }
    }
    /* Remember previous codes. */
    oldcode = incode;
  }

}
