#ifndef COMPRESS_H_GUARD
#define COMPRESS_H_GUARD

#include "byte_stream.h"

#define BITS 16
/*
 * a code_int must be able to hold 2**BITS values of type int, and also -1
 */
#if BITS > 15
typedef long int       code_int;
#else
typedef int	       code_int;
#endif

typedef	unsigned char  char_type;

#include "var_sym.h"

#define INIT_BITS 9			/* initial number of bits/code */

/*
 * the next two codes should not be changed lightly, as they must not
 * lie within the contiguous general code space.
 */ 
#define FIRST(block_compress)	((block_compress) ? 257 : 256)	/* first free entry */
#define	CLEAR	256	/* table clear output code */

#define MAX_MAX_CODE(maxbits) (1 << (maxbits))

#define MAXCODE(n_bits)	(MAX_MAX_CODE(n_bits) - 1)

void decompress(const int maxbits,
                const int block_compress,
                stream_state *in_stream,
                stream_state *out_stream);

void compress(const int maxbits,
              const int block_compress,
              stream_state *in_stream,
              stream_state *out_stream);

/* stuff to handle headers */
void
get_header(int *maxbits,
           int *block_compress,
           stream_state* in_stream);

int
put_header(const int maxbits,
           const int block_compress,
           stream_state* out_stream);

#endif COMPRESS_H_GUARD
