#ifndef STREAMS_H_GUARD
#define STREAMS_H_GUARD

typedef struct stream_state_struct {
  unsigned char* start;
  unsigned place;
  unsigned len;
} stream_state;

void
open_reader(stream_state *strm,
            unsigned char *buf,
            unsigned len);

void
open_writer(stream_state *strm,
            unsigned char *buf);

int
output_length(stream_state *strm);

int
getbyte(stream_state *strm);

void
putbyte(stream_state *strm,
        char c);

int
readbytes(stream_state *strm,
          char *buf,
          int n);

void
writebytes(stream_state *strm,
           char *buf,
           int n);

#ifndef EOF
#define EOF     (-1)
#endif

#endif STREAMS_H_GUARD
