#include "byte_stream.h"

void
open_reader(stream_state *strm,
            unsigned char *buf,
            unsigned len)
{
  strm->start = buf;
  strm->place = 0;
  strm->len = len;
}

void
open_writer(stream_state *strm,
            unsigned char *buf)
{
  strm->start = buf;
  strm->place = 0;
  strm->len = 0;
}

int
output_length(stream_state *strm)
{
  return strm->place;
}

int
getbyte(stream_state *strm)
{
  unsigned tmp = strm->place;
  if(tmp < strm->len)
  {
    unsigned int tmp2 = (unsigned int)(strm->start[tmp]);
    strm->place = tmp+1;
    return tmp2;
  }
  else
  {
    return( -1 );
  }
}

void
putbyte(stream_state *strm,
        char c)
{
  unsigned tmp = strm->place;
  strm->start[tmp] = c;
  tmp = tmp+1;
  strm->place = tmp;
}

int
readbytes(stream_state *strm,
          char *buf,
          int n)
{
  unsigned place = strm->place;
  unsigned len = strm->len;
  unsigned char* start = strm->start;
  int i = 0;

  if (n > (len - place)) {
    n = (len - place);
  }

  for (i = 0; i < n; i++) {
    buf[i] = start[place++];
  }

  strm->place = place;

  return n;
}

void
writebytes(stream_state *strm,
           char *buf,
           int n)
{
  unsigned place = strm->place;
  unsigned char* start = strm->start;
  int i;

  for (i = 0; i < n; i++)
  {
    start[place] = buf[i];
    place++;
  }

  strm->place = place;
}
