#ifndef TAG_FILE_H_GUARD
#define TAG_FILE_H_GUARD

#include <inttypes.h>
#include <vector>
#include <deque>

#include "bitops.h"

using namespace std;

extern bool is_load;
extern uint64_t cycle_count;
extern uint32_t superpipeline_factor;

class tag_file
{
private:
  size_t assoc;
  size_t address_bits_per_line;
  size_t num_sets;
  typedef pair<uint32_t, uint64_t> tag_t;
  typedef vector< tag_t > set_t;
  vector< set_t > the_tags;
  enum { INVALID = (uint32_t)-1 };
public:

  tag_file(uint32_t cache_size, // in bytes
           uint32_t line_size,  // in bytes
           uint32_t associativity) :
    assoc(associativity),
    address_bits_per_line(bitops::count_trailing_zeros(line_size)),
    num_sets(cache_size / (line_size * assoc)),
    the_tags(num_sets, set_t(assoc, tag_t(INVALID, 0)))
    { }

  uint64_t access(uint32_t vaddr, uint64_t current_time) {
    uint32_t the_tag = vaddr >> address_bits_per_line;
    size_t the_set = the_tag % num_sets;
    for (size_t i = 0; i < assoc; i++) {
      if (the_tags[the_set][i].first == the_tag) {
        // hit, move the tag to the front of the list
        uint64_t first_access = the_tags[the_set][i].second;
        for (size_t j = i; j > 0; j--) {
          // lru:
          the_tags[the_set][j] = the_tags[the_set][j-1];
        }
        the_tags[the_set][0].first = the_tag;
        the_tags[the_set][0].second = first_access;
        return first_access;
      }
    }
    // miss: replace the lru
    for (size_t j = assoc-1; j > 0; j--) {
      the_tags[the_set][j] = the_tags[the_set][j-1];
    }
    the_tags[the_set][0].first = the_tag;
    the_tags[the_set][0].second = current_time;
    return current_time;
  }
};

#endif /* TAG_FILE_H_GUARD */
