#include "rename_tables.h"
#include <assert.h>



rename_state::rename_state(uint32_t base_phys_reg):
  rat(NUM_ARCH_REGS)
{
  for(int i = 0; i< NUM_ARCH_REGS; i++) 
    rat[i] = base_phys_reg + i;
}

void rename_state::print() {
  std::cout<<"Printing rename state for context "<<context<<"\n";
  std::cout<<"Reg\tPhysReg\n";
  for(int i = 0; i< NUM_ARCH_REGS; i++)
    std::cout<<i<<"\t"<<rat[i]<<"\n";
}

void rename_state::print_map() {
  for(int i = 0; i < NUM_ARCH_REGS; ++i) {
    if(i % 8 == 0) printf("\n");
    printf("%3d->%3d  ", i, rat[i]);
  }
  printf("\n");
}

uint32_t rename_state::get_phys_reg(uint32_t arch_reg) const {
  return rat[arch_reg];
}


void rename_state::set_phys_reg(uint32_t arch_reg, uint32_t phys_reg){
  rat[arch_reg] = phys_reg;
}



vector<uint32_t> rename_state::get_all_phys_regs() {
  return rat;
}
