#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>
#include <vector>
#include <map>
#include <string.h>

#include "bitops.h"
#include "sparse_memory.h"
#include "decode.h"
#include "pretty_print.h"

#include "elf_loader.h"

using namespace std;

uint32_t debug_mask = 0;

struct memcpy_functor
{
  sparse_memory* the_mem;
  memcpy_functor(sparse_memory* m) : the_mem(m) { }
  void operator()(uint32_t dest, const void* src, size_t n) {
    the_mem->memcpy_from_host(dest, src, n);
  }
};


int
main(int argc, char* argv[])
{
  typedef elf_loader<memcpy_functor> loader_t;
  sparse_memory the_mem;
  char *string_tab = 0;
  loader_t::elf_return dri;
  memcpy_functor memcpy_func(&the_mem);
  loader_t the_loader;
  loader_t::text_sym_map_t sym_map;

  if (argc != 2) {
    fprintf(stderr, "usage: %s <exe-file-name>\n", argv[0]);
    exit(1);
  }

  int errval = the_loader.read_elf_file(argv[1], &memcpy_func, &dri, false);
  if (errval != 0) {
    fprintf(stderr, "%s: error loading %s!\n", argv[0], argv[1]);
    exit(1);
  }

  errval = the_loader.read_symtab(argv[1], &string_tab, &sym_map);
  if (errval != 0) {
    fprintf(stderr, "%s: error reading symtab\n", argv[0]);
    exit(1);
  }

  for (uint32_t addr = dri.start_segment;
       addr <= dri.end_segment;
       addr += 4)
  {
    loader_t::text_sym_map_t::const_iterator it = sym_map.find(addr);
    if (it != sym_map.end()) {
      printf("\n%s:\n", &(string_tab[it->second]));
    }
    decoder::instr_h the_instr = decoder::run(the_mem.load_uint32(addr));
    printf("%08x:\t", addr);
    pretty_print(the_instr);
    if (the_instr->is_link) {
      if (!the_instr->is_indirect_jump) {
        loader_t::text_sym_map_t::const_iterator targ =
          sym_map.find(the_instr->jump_immediate());
        if (targ != sym_map.end()) {
          printf(" <%s>", &(string_tab[targ->second]));
        }
      }
    }
    printf("\n");
  }

}
