#ifndef GLOBALS_H
#define GLOBALS_H

#include <inttypes.h>
#include <ext/hash_map>

#define NUM_ARCH_REGS 32

#define INV_POOL_PTR 0xFFFFFFFF

namespace __gnu_cxx {
  template <> struct hash<uint64_t> {
    size_t operator()(const uint64_t& s) const {
      return (size_t)(s ^ (s>>32));
    }
  };
}

// given the virtual address of a load/store and the size of the load/store,
// returns a bitmask in which a bit is set only if the load/store accesses
// the corresponding byte in the dword-aligned memory space
uint8_t get_access_bitmask(uint32_t vaddr, uint32_t size);

enum mispredict_type { t_branch, t_mem_access, t_syscall, t_branch_sset };

//sparse_mem behavior in arch_trace
enum e_sparse_mem_behavior {t_spmem_linked, t_spmem_unlinked_diverge, t_spmem_unlinked_em_syscalls, t_spmem_unlinked_copy_on_syscall};
//currently, when sparse_mem is unlinked, arch_trace diverges from true execution after a syscall
//to make it behave correctly when unlinked, you can either 
//a)emulate all syscalls in archtrace: looks ugly and doesn't always work
//b)copy sparse_mem from arch_model after a syscall


#endif
