#include "globals.h"

// given the virtual address of a load/store and the size of the load/store,
// returns a bitmask in which a bit is set only if the load/store accesses
// the corresponding byte in the dword-aligned memory space
uint8_t get_access_bitmask(uint32_t vaddr, uint32_t size) {
  uint8_t access_bytes = 0x00;

  switch (size) {
  case 1:
    access_bytes = 0x01;
    break;
  case 2:
    access_bytes = 0x03;
    break;
  case 4:
    access_bytes = 0x0f;
    break;
  case 8:
    access_bytes = 0xff;
    break;
  }

  for (uint8_t byte = 0; byte < (vaddr & 0x07); byte++)
    access_bytes = (access_bytes << 1);

  return access_bytes;
}
