#ifndef FRONTEND_DELAY_H
#define FRONTEND_DELAY_H

#include "circuit.h"
#include "packets.h"

using namespace std;

extern uint32_t superpipeline_factor;
extern uint32_t num_contexts;
extern uint64_t cycle_count;
extern uint32_t debug_mask;

class frontend_delay_stage : circuit {

  uint32_t			qhead; //location to insert to next, this location does not actually
                                       //hold something in the queue
  uint32_t			qsize;
  vector<decoder::instr_h>	instrq;
  vector<uint32_t>		inst_count;

  void recalc();
  void print_queue();
  void reset_totals();
  void flush_context(uint32_t x_context, uint64_t x_cancel_ts);
public:

  frontend_delay_stage(uint32_t fifo_size) :
    qhead(0),
    qsize(fifo_size),
    instrq(fifo_size, decoder::noop),
    inst_count(num_contexts, 0),
    instr_in(),
    branch_exec(),
    syscall_exec(),
    simpanic_in(),
    scoreboard_stall(),
    rename_stall(),
    rob_stall(),
    instr_out(decoder::noop),
    instr_counts(vector<uint32_t>(num_contexts, 0))
  { }
  
  //inports
  inport<decoder::instr_h>      instr_in;
  inport<branch_packet>      	branch_exec;      // branch misprediction info for completing instruction
  inport<mem_access_packet> 	mem_access_exec;  // load/store info for completing instruction
  inport<syscall_exec_packet> 	syscall_exec;     //syscall execution packet from exec unit
  inport<simpanic_packet>       simpanic_in;      //simpanic packet from rob. valid if retire checks failed
  inport<uint8_t>               scoreboard_stall;
  inport<uint8_t>               rename_stall;
  inport<vector<uint8_t> >      rob_stall;

  //outports
  statereg<decoder::instr_h>	instr_out;  
  statereg< vector<uint32_t> >  instr_counts;

};

#endif
