#include "free_list.h"

free_list::free_list(uint32_t init_num_entries, uint32_t init_val):
  queue(),
  max_objs(init_num_entries),
  ival(init_val)
{
  reset();
}

void free_list::reset()
{
  uint32_t x = 0;
  queue.clear();
  for (x = 0; x < max_objs; ++x)
    queue.push_back(x + ival);
}

void free_list::print() const
{
  uint32_t x, y;

  printf("free list (%d free objects)\n", queue.size());
  for (x = 0; x < queue.size(); x += 16) {
    for (y = 0; (y < 16) && (x+y < queue.size()); y++)
      printf("%3d ", queue[x+y]);
    printf("\n");
  }
}

uint32_t free_list::num_free_objs() const
{
  return queue.size();
}

bool free_list::get_free_obj(uint32_t& free_obj) {
  if (queue.size() > 0) {
    // get the object from the front of the queue
    free_obj = queue.front();

    // remove the object from the front of the queue
    queue.pop_front();
    return true;
  }
  else {
    assert(0);
    return false;
  }
}

void free_list::put_free_obj(uint32_t free_obj) {
  queue.push_back(free_obj);
}

bool free_list::duplicate_check() {
  map<uint32_t,int> mark;
  for(deque<uint32_t>::const_iterator i = queue.begin(), end = queue.end(); i != end; ++i) {
    if(mark[*i]) {
      printf("FREE_LIST:  Duplicate of %u found in free list\n", *i); 
      return true;
    }
    mark[*i] = true;
  }
  return false;
}
