#ifndef CONFIG_H
#define CONFIG_H

#include <inttypes.h>

#ifdef BIG_ENDIAN_HOST 
# ifdef LITTLE_ENDIAN_TARGET 
#  define REVERSE_BYTE_ORDER 1
# else
#  define REVERSE_BYTE_ORDER 0
# endif
#else
# ifdef LITTLE_ENDIAN_HOST
#  ifdef BIG_ENDIAN_TARGET
#   define REVERSE_BYTE_ORDER 1
#  else
#   define REVERSE_BYTE_ORDER 0
#  endif
# endif
#endif

#if REVERSE_BYTE_ORDER
#define CVT_ENDIAN_HWORD(x) ((((uint16_t)x) << 8) | \
                             (((uint16_t)x) >> 8))
#define CVT_ENDIAN_WORD(x) (                                            \
                            ( (((uint32_t)x) >> 24) ) |                 \
                            ( (((uint32_t)x) >>  8) & 0x0000FF00) |     \
                            ( (((uint32_t)x) <<  8) & 0x00FF0000) |     \
                            ( (((uint32_t)x) << 24) ) )

#define CVT_ENDIAN_DWORD(x) (                                           \
                             ( (((uint64_t)x) >> 56) ) |                \
                             ( (((uint64_t)x) >> 40) & 0x000000000000FF00ULL) | \
                             ( (((uint64_t)x) >> 24) & 0x0000000000FF0000ULL) | \
                             ( (((uint64_t)x) >>  8) & 0x00000000FF000000ULL) | \
                             ( (((uint64_t)x) <<  8) & 0x000000FF00000000ULL) | \
                             ( (((uint64_t)x) << 24) & 0x0000FF0000000000ULL) | \
                             ( (((uint64_t)x) << 40) & 0x00FF000000000000ULL) | \
                             ( (((uint64_t)x) << 56) ) ) 
#else
#define CVT_ENDIAN_HWORD(x) (x)
#define CVT_ENDIAN_WORD(x)  (x)
#define CVT_ENDIAN_DWORD(x) (x)
#endif

#ifdef _64_BIT_TARGET
typedef  uint64_t target_uintptr_t;
typedef   int64_t  target_intptr_t;
#else 
typedef  uint32_t target_uintptr_t;
typedef   int32_t  target_intptr_t;
#endif

#ifndef NDEBUG
# define ENABLE_DEBUG 1
#else
# define ENABLE_DEBUG 0
#endif

#ifdef _64_BIT_OFF_T
# define _64_BIT_OFF_T 1
# define _32_BIT_OFF_T 0
#else
# define _64_BIT_OFF_T 0
# define _32_BIT_OFF_T 1
#endif

#endif
