#ifndef ARCH_LISTNERS_H_GUARD
#define ARCH_LISTNERS_H_GUARD

#include "decode.h"
#include "arch-model.h"
#include "pretty_print.h"

// tracks cpath num of the last producer of each arch-reg.  For each
// instr_h's source regs we insert data in the instr_h about the cpath
// nums of the instrs that produced the data.
class track_last_writer : public arch_model::listener
{
public:
  // FIXME: mif 2005-Nov-19: making internal state public as a hack so
  // we can easily copy it from the rat and rob stages
  track_last_writer(arch_model* am);
  void notify(decoder::instr_h the_instr);
};

// tracks the current call depth and inserts the info into the instr_h
class track_call_depth : public arch_model::listener
{
  uint32_t call_depth;
public:
  track_call_depth(arch_model* am);
  void notify(decoder::instr_h the_instr);
};

// spews human readable state information at each instruction
// (including stack and reg files in addition to pc and the pretty
// printed instr).
class spew_state_info : public arch_model::listener
{
  FILE* tracefile;
public:
  spew_state_info(arch_model* am,
                  FILE* tf);
  void notify(decoder::instr_h the_instr);
};

#include <set>
#include <map>

// collects info about the observed cfg.  print() returns the
// collected cfg in human readable form.  We use the resulting file,
// in particular, to find out the realized indirect branches and to
// generate optimistic cdgs (that can, e.g., ignore branches that are
// never taken).
class gen_cfg : public arch_model::listener
{
  typedef set<uint32_t> node_set_t;
  typedef pair<uint32_t, uint32_t> cfg_edge_t;
  typedef map<cfg_edge_t, uint64_t> cfg_t; // the integer is the count.
  cfg_t the_count;
  cfg_t call_graph;
  node_set_t call_instrs;

  uint32_t entry_pt_pc;
public:
  gen_cfg(arch_model* am, uint32_t entry_pt);
  void notify(decoder::instr_h the_instr);
  void print(FILE* f);
};

#endif /* ARCH_LISTENERS_H_GUARD */
