#ifndef SCHEDULER_COMMON_H
#define SCHEDULER_COMMON_H

#include <vector>
#include <deque>
#include <list>
#include <map>
#include <algorithm>
#include <set>
#include "circuit.h"
#include "regfile_circuit.h"
#include "decode.h"
#include "pretty_print.h"
#include "issue_buffer.h"
#include "dependency_window.h"
#include "exec_unit.h"
#include "globals.h"
#include <ext/hash_map>

using namespace std;


class issue_buffer_object {
public:
  decoder::instr_h instr;
  bool issued;
  bool completed;
  
  issue_buffer_object(decoder::instr_h x_instr = decoder::noop) : 
    instr(x_instr),
    issued(false),
    completed(false)
  { }
};


class scheduler_core : circuit
{

  private:
    virtual void recalc() = 0;

  public:
    virtual void account_phys_regs(vector<uint32_t>&) const {}

    virtual ~scheduler_core() {
    }

    scheduler_core() :
      circuit(),
      // inputs
      instr_in(),
      rob_head(),
      retiring_instr(),
      branch_exec(),
      mem_access_exec(),
      mem_access_rob(),
      writeback_bus(),
      store_bus(),
      mem_access_stall(),
      syscall_exec(),
      simpanic_in(),

      // outputs
      instr_out(decoder::noop),
      scoreboard_stall(0)
    { 
    }

    // inputs from rename
    inport<decoder::instr_h> instr_in;

    // inputs from decode
    inport<vector<uint64_t> > decode_instr_num;

    // inputs from rob
    inport<vector<uint32_t> > rob_head;        // ptr to instruction ready to retire
    inport<decoder::instr_h>  retiring_instr;  // to clean up cancel_ranges

    // inputs from exec_unit
    inport<branch_packet>     branch_exec;     // branch misprediction info for completing instruction
    inport<mem_access_packet> mem_access_exec; // load/store info for completing instruction
    inport<branch_packet>     branch_rob;
    inport<mem_access_packet> mem_access_rob;  // load/store info for retiring instruction
    inport<bus_packet>        writeback_bus;
    inport<store_bus_packet>  store_bus;

    // stall issue of loads/stores due to execution of load/store not recorded in sbc/tsc
    inport<vector<uint8_t> >  mem_access_stall;  

    inport<syscall_exec_packet> syscall_exec;  //syscall execution packet
    inport<simpanic_packet>   simpanic_in;
    inport<vector<uint32_t> > frontend_delay_counts; //num of insts from each context in the frontend queue

    // outputs
    statereg<decoder::instr_h> instr_out;
    statereg<uint8_t>          scoreboard_stall;
};


#endif

