#ifndef RENAME_STAGE_COMMON_H
#define RENAME_STAGE_COMMON_H

#include "circuit.h"
#include "regfile_circuit.h"
#include "packets.h"
#include "rename_tables.h"
#include "free_list.h"
#include <algorithm>
#include <vector>
#include <deque>
#include <iostream>
#include "globals.h"
#include <map>
using namespace std;

// Alpha Style Renaming
// 1. For a load/store, create the checkpoint BEFORE renaming the instruction, because
//    that instruction will be renamed again in the event of a misspeculation.
// 2. For a branch, create the checkpoint AFTER renaming the instruction, because
//    that instruction will not be renamed again in the event of a misprediction.
// 3. Each branch/load/store instruction carries a rat_checkpt index (the index
//    of the rat checkpoint for that instruction). When a misprediction/misspeculation
//    is detected, the renamer resets the active rat to the designated checkpoint.

extern uint32_t num_phys_regs;    // commandline parameter, default is 64
extern uint32_t num_contexts;       // commandline parameter, default is 1
extern uint32_t rob_size;         // commandline parameter, default is 64
extern uint32_t debug_mask;       // rename stage debug_mask is 0x00000004
                                  // RAT and RRAT debug_mask is 0x00000080
                                  // free list debug_mask is    0x00040000
                                  //reference counts: 0x40000
extern uint64_t cycle_count;

class rename_stage_core : circuit
{
  private:
    virtual void recalc() = 0;

  public:
    //this functions should mark the phys regs currently in use within
    //the rename stage for use during a bullet proof check cycle
    virtual void account_phys_regs(vector<uint32_t>& phys_regs) const 
    {
      //dont worry about this yet!
    }
  
    rename_stage_core::rename_stage_core() :
      circuit(),
      // inputs
      instr_in(),
      branch_exec(),
      mem_access_exec(),
      scoreboard_stall(),
      rob_stall(),
      retiring_instr(),
      syscall_exec(),
      simpanic_in(),

      // outputs
      instr_out(decoder::noop),
      rename_stall(false)
    {
    }

    virtual ~rename_stage_core() {
    }

    // inputs    
    inport<decoder::instr_h>  instr_in;          // input from store set stage
    inport<branch_packet>     branch_exec;       // branch misprediction info for completing instruction
    inport<mem_access_packet> mem_access_exec;   // load/store info for completing instruction
    inport<branch_packet>     branch_rob;
    inport<mem_access_packet> mem_access_rob;
    inport<uint8_t>           scoreboard_stall;
    inport<vector<uint8_t> >  rob_stall;
    inport<decoder::instr_h>  retiring_instr;    // free list info for retiring instructions
    inport<syscall_exec_packet> syscall_exec;  //syscall execution packet from exec unit
    inport<simpanic_packet>   simpanic_in;  //recovery from retire-check failures

    // outputs
    statereg<decoder::instr_h> instr_out;
    statereg<uint8_t>          rename_stall;

};


#endif /* RENAME_STAGE_H */
