#ifndef RENAME_STAGE_H
#define RENAME_STAGE_H

#include "circuit.h"
#include "regfile_circuit.h"
#include "packets.h"
#include "rename_tables.h"
#include "free_list.h"
#include <algorithm>
#include <vector>
#include <deque>
#include <iostream>
#include "globals.h"
#include <map>
#include "rename_stage_common.h"

using namespace std;

// SMT
// 1. One RAT and one RRAT per thread.
//    When renaming an instr, select RAT based on arriving instr's context.
//    When retiring an instr, select RRAT based on retiring instr's context.
//    When handling a retired mispredict, select RAT and RRAT based on mispredicted branch's context.

// Alpha Style Renaming
// 1. For a load/store, create the checkpoint BEFORE renaming the instruction, because
//    that instruction will be renamed again in the event of a misspeculation.
// 2. For a branch, create the checkpoint AFTER renaming the instruction, because
//    that instruction will not be renamed again in the event of a misprediction.
// 3. Each branch/load/store instruction carries a rat_checkpt index (the index
//    of the rat checkpoint for that instruction). When a misprediction/misspeculation
//    is detected, the renamer resets the active rat to the designated checkpoint.

extern uint32_t num_phys_regs;    // commandline parameter, default is 64
extern uint32_t num_contexts;       // commandline parameter, default is 1
extern uint32_t rob_size;         // commandline parameter, default is 64
extern uint32_t debug_mask;       // rename stage debug_mask is 0x00000004
                                  // RAT and RRAT debug_mask is 0x00000080
                                  // free list debug_mask is    0x00040000
                                  //reference counts: 0x40000
extern uint64_t cycle_count;

class rename_stage : public rename_stage_core
{
 private:
  void print_debug_info();  //print stats when debug flag(s) are set
  void recalc();

 public:
  rename_stage::rename_stage() :
    rename_stage_core()
  {
  }

  ~rename_stage() {
  }

};


#endif /* RENAME_STAGE_H */
