#include "rename_stage.h"


inline void rename_stage::print_debug_info() {
  if (debug_mask & 0x00000004) {
    instr_out()->print("RENAME OUT> instr");
    printf("\n");
    instr_in()->print("RENAME IN> instr");
    printf("\n");
  }
}


void rename_stage::recalc() 
{
  print_debug_info();

  // THIS PART OF THE CODE HANDLES THE INSTRUCTION ARRIVING FROM THE DECODER:
  if (scoreboard_stall() || rename_stall() || (rob_stall()[0])) {
    //FIXME: We seem to be touching output latches during a backend stall.. why ?
    // stall detected: in all cases this should produce a no-op on the output
    decoder::instr_h temp_instr = decoder::noop;
    instr_out = temp_instr;
  }
  else {
    if (simpanic_in().valid || branch_exec().mispredict || 
        mem_access_exec().misspeculation || syscall_exec().valid) {
      instr_out = decoder::noop;
    } else {
      decoder::instr_h instr = instr_in();
      //FIXME: do dummy renaming... until the rest of the backend structures are fixed !!
      instr->phys_s_reg = instr->arch_s_reg;
      instr->phys_t_reg = instr->arch_t_reg;
      instr->phys_dest_reg = instr->arch_dest_reg;
      instr_out = instr;
    }
  }

  // THIS PART OF THE CODE HANDLES THE INSTR THAT IS RETIRING FROM THE ROB
  if (retiring_instr()->completed) {
    if (retiring_instr()->canceled) {
      // rob is telling us about a cancelled instruction (one that is being 
      //flushed because of a mispredict)
    }
    else {
      // instruction completed and is not canceled: normal retirement
    }
  }

  // THIS PART OF THE CODE HANDLES RENAMER STATE CHANGES THAT OCCUR
  // BECAUSE OF A MISPREDICT.  NOTE: Jump-and-link instructions (jal
  // and jalr) can both mispredict and write back to a register
  // (always architectural register 31).  Thus, during a cycle that
  // a mispredicted jump-and-link retires both
  // branch_mispredict.mispredicted_branch and
  // retiring_instr->completed will be true.
  if (branch_exec().mispredict) {
  }

  // THE RENAMER STALLS WHEN IT GETS CLOSE TO RUNNING OUT OF
  // REGISTERS IN ITS FREELIST.  THIS SIGNAL TELLS THE FETCH AND
  // DECODE UNITS TO STALL.  NOTE THAT THIS SIGNAL DOESN'T GET TO
  // THE DECODER UNTIL *AFTER* THE NEXT CLOCK EDGE, SO ONE MORE
  // INSTRUCTION IS GOING TO ARRIVE ON THE NEXT CLOCK EDGE, AND YOU
  // BETTER HAVE THE RESOURCES TO DEAL WITH IT.
  rename_stall = false; 
  // inorder machine doesn't rename, so freelist n ever gets empty
}


