
#ifndef POOL_H
#define POOL_H

#include <inttypes.h>

#include "free_list.h"

template<typename T>
class pool_c {
private:
  free_list the_free_list;
  vector<T> the_pool;
  uint32_t size;
public:
  pool_c(uint32_t x_size) :
    the_free_list(x_size, 0),
    the_pool(x_size),
    size(x_size)
  { }

  T& get(uint32_t entry) {
    return the_pool[entry];
  }

  uint32_t insert(const T& x_obj) {
    uint32_t entry;
    the_free_list.get_free_obj(entry);
    the_pool[entry] = x_obj;
    return entry;
  }

  void remove(uint32_t x_entry) {
    the_free_list.put_free_obj(x_entry);
    the_pool[x_entry] = T();
  }

  uint32_t num_free() { 
    return the_free_list.num_free_objs();
  }

  uint32_t num_used() {
    return size - the_free_list.num_free_objs();
  }

};

#endif
