#ifndef LSQ_PACKETS_H_GUARD
#define LSQ_PACKETS_H_GUARD

// LSQ Packets
// lsq_packet contains fields common to ldq and stq packets
// ldq_packet is derived from lsq_packet and contains additional fields
//  specific to ldq
// stq_packet is derived from lsq_packet and contains additional fields
//  specific to stq

#include <vector>
#include "globals.h"
using namespace std;

extern uint32_t num_contexts;

class lsq_packet {
public:
  uint32_t context;
  bool completed;
  bool canceled;
  uint32_t address;
  uint32_t size;
  uint64_t inum;

  lsq_packet();
  void print() const;
};

class stq_packet : public lsq_packet {
public:
  uint64_t data;

  stq_packet();
  void print() const;

private:
  void interflow_print() const;
};

class ldq_packet : public lsq_packet {
public:
  uint32_t instr_pc;
  size_t   rob_slot;
  uint32_t rat_checkpt;
  uint32_t prev_pc;

  ldq_packet();
  void print() const;
};

#endif /* LSQ_PACKETS_H_GUARD */
