#include "lsq_packets.h"

// LSQ packet (base class)
lsq_packet::lsq_packet() : 
  context(~0),
  completed(false),
  canceled(false),
  address(~0),
  size(0),
  inum(0ULL)
{ }

void lsq_packet::print() const {
  printf("addr %08x size %u ctext %u ts %llu comp %d canc %d ",
          address, size, context, inum, completed, canceled);
}

// STQ packet (derived from lsq packet)
stq_packet::stq_packet() :
  data(0xdeadbeef)
{ }

void stq_packet::print() const {
  lsq_packet::print();
  printf("data %016llx\n", data);
}

// LDQ packet (derived from LSQ packet)
ldq_packet::ldq_packet() :
  instr_pc(0xdead2fec),
  rob_slot((size_t)(-1)),
  rat_checkpt(0),
  prev_pc(~0)
{ }

void ldq_packet::print() const {
  lsq_packet::print();
  printf("pc %08x rob %u ratchk %u prevpc %08x \n",
	      instr_pc, rob_slot, rat_checkpt, prev_pc);
}
