/* -*- C++ -*- */

#ifndef LONG_BITVECTOR
#define LONG_BITVECTOR

#include <math.h>

class long_vector_c {
public:
  //my_data[0] bit 0 is most recent....
  std::vector<uintptr_t> my_data;
  uintptr_t high_mask;
  bool repair;

  long_vector_c(int bits=512) {
    my_data.resize((uint32_t) ceil(bits/(float)(sizeof(uintptr_t)*8)) );
    high_mask = 1 << (sizeof(uintptr_t)*8 - 1);
  }

  long_vector_c(const long_vector_c& copy) {
    my_data = copy.my_data;
    high_mask = copy.high_mask;
    repair = copy.repair;
  }



  void update(bool bit) {
    repair = (my_data[my_data.size()-1]&high_mask ? 1 : 0);
    for(int i = my_data.size()-1; i>=1; i--) {
      my_data[i] <<= 1;
      my_data[i]  |= (my_data[i-1]&high_mask ? 1 : 0);
    }
    my_data[0] <<= 1;
    my_data[0]  |= bit;
  }

  void de_update() {
    my_data[0] >>= 1;
    for(uint32_t i = 1; i<my_data.size(); i++) {
      my_data[i-1]  |= (my_data[i]&0x1) << (sizeof(uintptr_t)*8-1);
      my_data[i] >>= 1;
    }
    my_data[my_data.size()-1] |= (repair << (sizeof(uintptr_t)*8-1));
  }
  
  bool operator[](uint32_t bit) {
    uint32_t datum  = bit/(sizeof(uintptr_t)*8);
    uint32_t offset = bit%(sizeof(uintptr_t)*8);
    return ( my_data[datum] & (1 << offset) ? true : false);
  }

  const bool operator[](uint32_t bit) const {
    uint32_t datum  = bit/(sizeof(uintptr_t)*8);
    uint32_t offset = bit%(sizeof(uintptr_t)*8);
    return ( my_data[datum] & (1 << offset) ? true : false);
  }

  uintptr_t summary() const {
    return my_data[0];
  }

};

#endif
