#ifndef INORDER_SCHEDULER_H
#define INORDER_SCHEDULER_H

#include <vector>
#include <deque>
#include <list>
#include <map>
#include <algorithm>
#include <set>
#include "circuit.h"
#include "regfile_circuit.h"
#include "decode.h"
#include "pretty_print.h"
#include "issue_buffer.h"
#include "dependency_window.h"
#include "exec_unit.h"
#include "globals.h"
#include <ext/hash_map>
#include "scheduler_common.h"

using namespace std;

// Global variable potentially defined on command line
extern uint32_t num_phys_regs;
extern uint32_t issue_buffer_size;
extern uint32_t num_contexts;
extern uint32_t debug_mask;            // scoreboard stage debug_mask is 0x00000008

extern uint64_t lsq_store_stall_cnt;
extern uint64_t lsq_load_stall_cnt;

extern uint64_t cycle_count;

extern uint32_t superpipeline_factor;
extern bool     schd_reg_dep_first;
extern bool     schd_histogram_accounting;
extern bool     bullet_proof_check_cycle;

enum schd_state_t {EMPTY,WAITING,READY};

//Debug mask for this stage is 0x00800000

class inorder_scheduler : public scheduler_core
{
  private:
    execution_unit* the_exec_unit; //for allocating slots in the lsq at dispatch time
    vector<bool> score_board;
    decoder::instr_h held_instr;
    schd_state_t schd_state;
    deque<decoder::instr_h> pre_fifo;

    void recalc();
    void handle_writeback();
    void handle_misspeculation();
    void handle_issue_dispatch();
    void set_stall_conditions();
    void print_debug();
    void handle_pre_fifo();
    bool syscall_check(decoder::instr_h instr);

    //default values
    static uint32_t pre_fifo_size;
    static const uint32_t pre_fifo_unused_limit;
 

  public:
    void account_phys_regs(vector<uint32_t>&) const {
      //No implementation required for in-order, non renaming
    }

    ~inorder_scheduler() {
    }

    inorder_scheduler(execution_unit* exec_unit) :
      scheduler_core(),
      the_exec_unit(exec_unit),
      score_board(NUM_ARCH_REGS,true),
      held_instr(decoder::noop),
      schd_state(EMPTY),
      pre_fifo(0, decoder::noop)
    { 
      inorder_scheduler::pre_fifo_size = issue_buffer_size;
      assert(inorder_scheduler::pre_fifo_size > inorder_scheduler::pre_fifo_unused_limit);
    }

};

#endif /* SCHEDULER_H */

