#ifndef EXECUTE_H_GUARD
#define EXECUTE_H_GUARD

#include <inttypes.h>
#include "decode.h"

using namespace std;

class state_semantics
{
public:
  virtual uint64_t s_op64(decoder::instr_h instr) = 0;
  virtual uint64_t t_op64(decoder::instr_h instr) = 0;
  virtual uint64_t& dest(decoder::instr_h instr) = 0;

  virtual uint64_t load_int8(uint32_t vaddr, uint32_t context=0) = 0;
  virtual uint64_t load_uint8(uint32_t vaddr, uint32_t context=0) = 0;
  virtual uint64_t load_int16(uint32_t vaddr, uint32_t context=0) = 0;
  virtual uint64_t load_uint16(uint32_t vaddr, uint32_t context=0) = 0;
  virtual uint64_t load_int32(uint32_t vaddr, uint32_t context=0) = 0;
  virtual uint64_t load_uint32(uint32_t vaddr, uint32_t context=0) = 0;
  virtual uint64_t load_uint64(uint32_t vaddr, uint32_t context=0) = 0;
  virtual void store_uint8(uint8_t data, uint32_t vaddr, uint32_t context=0) = 0;
  virtual void store_uint16(uint16_t data, uint32_t vaddr, uint32_t context=0) = 0;
  virtual void store_uint32(uint32_t data, uint32_t vaddr, uint32_t context=0) = 0;
  virtual void store_uint64(uint64_t data, uint32_t vaddr, uint32_t context=0) = 0;
  virtual void memcpy_to_host(void* dest, const uint32_t src, size_t n, uint32_t context=0) = 0;
  virtual void memcpy_from_host(uint32_t dest, const void* src, size_t n, uint32_t context=0) = 0;
  virtual void strcpy_to_host(char* dest, const uint32_t src, uint32_t context=0) = 0;
  virtual void strcpy_from_host(uint32_t dest, const char* src, uint32_t context=0) = 0;
  virtual void emulate_syscall(uint32_t cmd_addr, uint32_t context=0) = 0;
  virtual uint32_t& program_counter() = 0;
  virtual void halt() = 0;
  virtual void zero_reg_0() = 0;
  virtual void print_err_msg(char*) = 0;
  virtual ~state_semantics() { }
};

struct datapath_reg_init {
  uint32_t start_text;
  uint32_t end_text;
  uint32_t pc;
  uint64_t reg_29;
  uint64_t reg_4;
  uint64_t reg_5;
};

class datapath
{
private:
  state_semantics* state;
  uint32_t s_op32(decoder::instr_h instr) {
    return (uint32_t)(state->s_op64(instr));
  }
  uint32_t t_op32(decoder::instr_h instr) {
    return (uint32_t)(state->t_op64(instr));
  }
  int64_t sign_extend64(uint32_t val) {
    int32_t sval = val;
    return (int64_t)sval;
  }


public:
  datapath(state_semantics* ts) : state(ts) { }

  void execute(decoder::instr_h instr);
  int load_elf_file(const char* filename,
                    int argc,
                    char* argv[],
                    datapath_reg_init* dri);
};

#endif /* EXECUTE_H_GUARD */
