#ifndef DECODE_STAGE_H
#define DECODE_STAGE_H

#include <deque>
#include <map>
#include "circuit.h"
#include "decode.h"
#include "packets.h"
#include "pretty_print.h"

using namespace std;

extern uint32_t debug_mask;  // decode stage debug_mask is 0x00000002
extern uint32_t superpipeline_factor;
extern uint32_t num_contexts;
extern uint64_t cycle_count;

class decode_stage : circuit
{
 private:
  vector<uint32_t>      prev_pc;

  void init_state();

  void print_debug_info();

  void recalc();

 public:
  // inits
  decode_stage() :
    circuit(), 
    prev_pc(num_contexts, ~0),
    instr_in(),
    program_counter_in(),
    predicted_pc_in(),
    ra_stack_ptr_in(),
    ra_stack_head_in(),
    context(),
    btb_miss_in(),
    branch_exec(),
    mem_access_exec(),
    scoreboard_stall(),
    rename_stall(),
    rob_stall(),
    syscall_exec(),
    simpanic_in(),
    instr_out(decoder::noop),
    instr_num(vector<uint64_t>(num_contexts,0))
    {  }

  // inputs from ifetch:
  inport<uint32_t> instr_in;

  inport<uint32_t> program_counter_in;
  inport<uint32_t> predicted_pc_in;
  inport<uint32_t> ra_stack_ptr_in;
  inport<uint32_t> ra_stack_head_in;
  inport<uint32_t> context;
  inport<uint8_t>  btb_miss_in;

  inport<branch_packet>      branch_exec;      // branch misprediction info for completing instruction
  inport<mem_access_packet>  mem_access_exec;  // load/store info for completing instruction
  inport<uint8_t>               scoreboard_stall;
  inport<uint8_t>               rename_stall;
  inport<vector<uint8_t> > rob_stall;
  inport<syscall_exec_packet> syscall_exec;  //syscall execution packet from exec unit
  inport<simpanic_packet> simpanic_in;  //simpanic: retire check failures

  // outputs
  statereg<decoder::instr_h> instr_out;
  statereg<vector<uint64_t> > instr_num;

};

#endif /* DECODE_STAGE_H */
