#include "decode_stage.h"


inline void decode_stage::print_debug_info()
{
  if (debug_mask & 0x00000002) {
    // print the instruction that is arriving at the renamer
    printf("DECODE IN> tid %d instr %x   pc %x\n", context(), instr_in(), program_counter_in());
    instr_out()->print("DECODE OUT>");
    printf(" ");
    pretty_print(instr_out());
    printf("\n");
  }
}

void decode_stage::init_state()
{ }


void decode_stage::recalc() {
  vector<uint64_t> instr_num_out = instr_num();

  init_state();

  print_debug_info();

  if (scoreboard_stall() || rename_stall() || rob_stall()[0]) {
    // stall detected

    if (instr_out()->noop ||
        (simpanic_in().mispredicted_context(instr_out()->context)) ||  
        (branch_exec().mispredicted_context(instr_out()->context)) ||
        (mem_access_exec().mispredicted_context(instr_out()->context)) ||
        (syscall_exec().valid && syscall_exec().context == instr_out()->context)) {

      // state: stall detected and misprediction or misspeculation detected in the thread that
      //  owns the instruction that is in the output latch
      // action: flush the instruction in the output latch

      decoder::instr_h temp_instr = decoder::noop;
      instr_out = temp_instr;
    }
  }
  else {
    // no stall detected
    // misspeculation has occurred
    if(simpanic_in().mispredicted_context(context()) ||
       branch_exec().mispredicted_context(context()) ||
       mem_access_exec().mispredicted_context(context()) ||
       (syscall_exec().valid && syscall_exec().context == context())) {
      // state: no stall detected, but misprediction or misspeculation detected in the thread
      //  that owns the instruction in the input latch
      // action: flush the instruction from the mispredicting/misspeculating thread
      
      instr_out = decoder::noop;
    }
    else if(instr_in() == 0) {
      //state: no stall, no misprediction/misspeculation, but IFetch gave no-op
      //action: pass noop to next stage
      instr_out = decoder::noop;
    }
    else {
      // state: no stall detected, and no misprediction/misspeculation detected in the thread, and 
      //ifetch did NOT give a nop
      //  that owns the instruction at the input to the decoder
      // action: decode the instruction and put the decoded instruction in the output latch
        
      // decode the instruction in the input latch
      decoder::instr_h the_instr   = decoder::run(instr_in());
      the_instr->decode_ts         = cycle_count;
      the_instr->bus_latency       *= superpipeline_factor;
      the_instr->program_counter    = program_counter_in();

      the_instr->predicted_pc       = predicted_pc_in();
      the_instr->ra_stack_ptr       = ra_stack_ptr_in();
      the_instr->ra_stack_head      = ra_stack_head_in();
      the_instr->context            = context();
      the_instr->prev_pc            = prev_pc[context()];
      prev_pc[context()]            = program_counter_in();

      // update the instruction numbering
      the_instr->instr_num = instr_num_out[0];
      instr_num_out[0]++;
      
      // send the decoded instruction to the renamer
      instr_out = the_instr;
    }
  }
  instr_num = instr_num_out;
}
