/* -*-C++-*- */
#ifndef CIRCUIT_H
#define CIRCUIT_H

#include <stdio.h>
#include <assert.h>
#include <set>
#include <inttypes.h>
#include <vector>

using namespace std;

class clocked_net
{
private:
  typedef set<clocked_net*> net_list_t;
  static net_list_t* net_list;
  static uint32_t num_statereg;
protected:
  //static uint32_t sizeof_data;
  //static uint64_t num_unmodified;
public:
  clocked_net();
  virtual void do_pulse() = 0;
  static void pulse();
  static void print(uint64_t);
  virtual ~clocked_net();
};

template <class T>
class port
{
public:
  virtual T& operator()() const = 0;
  virtual ~port() { }
};

class circuit
{
private:
  typedef set<circuit*> circuit_list_t;
  static circuit_list_t* circuit_list;
public:
  circuit();
  virtual void recalc() = 0;
  static void level();
  virtual ~circuit();
};

template <class T>
class statereg : clocked_net, public port<const T>
{
  bool unmodified;
  std::vector<T> state;//autoconstructor -- for valgrind
  T* current_state;
  T* next_state;


  void do_pulse() { 
    if(unmodified) { 
      *next_state = *current_state;
      /*++num_unmodified;*/
    }
    else {
      unmodified = true;

      // swap the state
      T* temp_state = next_state;
      next_state = current_state;
      current_state = temp_state;
    }
  }
  void operator=(const statereg& v) { }
public:
  statereg() : 
    clocked_net(), 
    unmodified(true), 
    state(2) {
    current_state =(&(state[0]));
    next_state    =(&(state[1]));
  }
  statereg(const T& val) : 
    clocked_net(), 
    unmodified(true), 
    state(2) {
    current_state =(&(state[0]));
    next_state    =(&(state[1]));
    state[0] = state[1] = val; /*sizeof_data += sizeof(T);*/ }
  statereg(const statereg& v) : 
    clocked_net(), 
    unmodified(true), 
    state(2) {
    current_state =(&(state[0]));
    next_state    =(&(state[1]));
    state[0] = v.state[0]; 
    state[1] = v.state[1]; /*sizeof_data += sizeof(T);*/ }

  T& operator*() { 
    if(unmodified) { 
      *next_state = *current_state;
      unmodified = false;
    }
    return *next_state; 
  }
  void operator=(const T& v) { *next_state = v; unmodified = false; }
  const T& operator()() const { return *current_state; }
  const T& peek() const { return *next_state; }
  void reset(const T& val) { state[0] = val; state[1] = val; }
};

template<class T>
class inport : public port<const T>
{
  const port<const T>* the_net;
public:
  inport() : the_net(0) { }
  void attach(const port<const T>*const n) {
    assert(the_net == 0);
    the_net = n;
  }
  const T& operator()() const {
    assert(the_net != 0);
    return the_net->operator()();
  }
};

template <class T>
class memo_func : clocked_net, public port<const T>
{
  bool valid;
  T current_state;
  void do_pulse() { valid = 0; }
  virtual T do_access() const = 0;
public:
  memo_func() : clocked_net() { valid = 0; }
  const T& operator()() const {
    if (!valid) {
      memo_func* th = const_cast<memo_func*>(this);
      th->current_state = th->do_access();
      th->valid = 1;
    }
    return current_state; 
  }
  virtual ~memo_func() { }
};

template <class S, class T>
class member_outport : public memo_func<T>
{
  S* the_object;
  typedef T (S::* member_func_t)();
  member_func_t the_member_func;
  T do_access() const { return (the_object->*the_member_func)(); }
public:
  member_outport(S* obj, member_func_t mf) :
    memo_func<T>(),
    the_object(obj),
    the_member_func(mf)
    { }
};

#define outport inport

#endif /* CIRCUIT_H */
